//=============================================================================
//              |
// Headerfile   |  BT.h
//              |
// Description  |  Bluetooth helper API definitions
//              |
//-----------------------------------------------------------------------------
// Disclaimer - Exclusion of Liability
//
// This software is distributed in the hope that it will be useful,but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. It can be used an modified by anyone
// free of any license obligations or authoring rights.
//=============================================================================

#ifndef __BT_H__
#define __BT_H__

#include "common.h"
#include "ROBO_TX_FW.h"

#ifdef __cplusplus
extern "C" {
#endif

enum bt_commands_e
{
    CMD_NO_CMD,
    CMD_CONNECT,
    CMD_DISCONNECT,
    CMD_START_LISTEN,
    CMD_STOP_LISTEN,
    CMD_START_RECEIVE,
    CMD_STOP_RECEIVE,
    CMD_SEND
};

extern UCHAR8 bt_address_table[BT_CNT_MAX][BT_ADDR_LEN];


//  converts Bluetooth address to a string
char * BtAddrToStr
(
    UCHAR8 * btaddr,
    char * str
);

//  converts the status of the executed Bluetooth command to a string
char * BtCommandStatusToString
(
    enum bt_commands_e command,
    CHAR8 command_status
);

//  displays the status of the executed Bluetooth command as the string having
//  such format:
//      "Ch <channel>, <bt_address>\n<status of Bluetooth command as a string>\n"
void BtDisplayCommandStatus
(
    UCHAR8 * bt_address,
    UINT32 channel,
    enum bt_commands_e command,
    CHAR8 command_status
);


#ifdef __cplusplus
}   //  balance extern "C" above
#endif

#endif // __BT_H__
